{*
 * Shopimind
 *
 * @author    Shopimind
 * @copyright Copyright (c) Shopimind 2021
 * @license   Commercial license
 *}

<fieldset id="configuration_form_1" class="shopimind" {if {$visibility|escape:'htmlall':'UTF-8'} == 'hide'} style="display:none" {/if}>
    <legend style="background:#fff;">
        <img src="{$logo|escape:'htmlall':'UTF-8'}"  alt="" title=""/>
        {l s='Create my ShopiMind account' mod='shopimind'}
    </legend>

    <form  method="post" action="{$url_register|escape:'htmlall':'UTF-8'}" name="remoteRegister">
        <div class="control-group">
            <label for="shop[user][email]">
                {l s='Email address' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$PS_SHOP_EMAIL|escape:'htmlall':'UTF-8'}" name="shop[user][email]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][password]">
                {l s='Password' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="password" value="" name="shop[user][password]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][passwordConfirm]">
                {l s='Confirm password' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="password" value="" name="shop[user][passwordConfirm]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[url]">
                {l s='Shop URL' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$shop_url|escape:'htmlall':'UTF-8'}" name="shop[url]" placeholder="http://" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][firstName]">
                {l s='First name' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="" name="shop[user][firstName]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][lastName]">
                {l s='Last name' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="" name="shop[user][lastName]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][societe]">
                {l s='Company' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$ps_shop_name|escape:'htmlall':'UTF-8'}" name="shop[user][societe]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][vat_number]">
                {l s='VAT number' mod='shopimind'}:
            </label>
            <input type="text" value="" name="shop[user][vat_number]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][phoneFixe]">
                {l s='Landline number' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$ps_phone|escape:'htmlall':'UTF-8'}" name="shop[user][phoneFixe]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][phoneMobile]">
                {l s='Mobile phone number' mod='shopimind'}<span style="color:#cc0000;">*</span> :</label>
            <input type="text" value="{$ps_phone|escape:'htmlall':'UTF-8'}" name="shop[user][phoneMobile]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][rue]">
                {l s='Address' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$ps_shop_addr1|escape:'htmlall':'UTF-8'}" name="shop[user][rue]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][complement]">
                {l s='Address 2' mod='shopimind'} :
            </label>
            <input type="text" value="{$ps_shop_addr2|escape:'htmlall':'UTF-8'}" name="shop[user][complement]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][bp]">{l s='PO Box' mod='shopimind'} :</label>
            <input type="text" value="" name="shop[user][bp]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][zipCode]">
                {l s='Zip code' mod='shopimind'} <span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$ps_zip_code|escape:'htmlall':'UTF-8'}" name="shop[user][zipCode]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][city]">
                {l s='City' mod='shopimind'} <span style="color:#cc0000;">*</span> :
            </label>
            <input type="text" value="{$ps_city|escape:'htmlall':'UTF-8'}" name="shop[user][city]" style="width:400px;" /><br />
        </div><br />

        <div class="control-group">
            <label for="shop[user][country]">
                {l s='Country' mod='shopimind'}<span style="color:#cc0000;">*</span> :
            </label>
            <select name="shop[user][country]" style="width:400px;">
                <option value="">{l s='Automatic' mod='shopimind'}</option>
                {foreach from=$countries key=k item=country}
                    {if {$ps_shop_country_id|escape:'htmlall':'UTF-8'} eq {$country.iso_code|escape:'htmlall':'UTF-8'}}
                        <option value="{$country.iso_code|escape:'htmlall':'UTF-8'}" selected="selected">
                            {$country.name|escape:'htmlall':'UTF-8'}
                        </option>
                    {else}
                        <option value="{$country.iso_code|escape:'htmlall':'UTF-8'}">
                            {$country.name|escape:'htmlall':'UTF-8'}
                        </option>
                    {/if}
                {/foreach}
            </select>
            <br />
        </div>
        <br />
        <input type="hidden" value="prestashop" name="shop[solutionEcommerce]" />

        <input type="text" value="{$promo_code|escape:'htmlall':'UTF-8'}" name="shop[user][promoCode]" />

        <div style="text-align:center;">
            {if {$SPM_apiIdentification|escape:'htmlall':'UTF-8'} == ''}
                <input type="button" style="padding-right:10px;" class="button spm_back_config_page" value="{l s='Back' mod='shopimind'}" />
            {/if}
            <input type="button" class="button" id="submitRemoteRegister" value="{l s='Submit' mod='shopimind'}" />
        </div>

    </form>
</fieldset>


<script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script type="text/javascript">
    {literal}
    var jqspm = jQuery.noConflict();
    $("#submitRemoteRegister").bind("click", function () {
        $("#submitRemoteRegister").attr("disabled","disabled");
        var defaultSubmitValue = $("#submitRemoteRegister").attr("value");
        $("#submitRemoteRegister").attr("value","{/literal}{l s='Please wait' mod='shopimind'}{literal}");
        var $form = $('form[name="remoteRegister"]');
        $("ul.errors",$form).remove();
        jqspm.ajax({
            type: "POST",
            crossDomain: true,
            dataType: "json",
            url: $form.attr("action"),
            data: $form.serialize(),
            success:function(response){
                if (response.success === true) {
                    var apiKey = response.apiKey;
                    var identifiant = response.identifiant;
                    $('input[name="apiIdentification"]').val(identifiant);
                    $('input[name="apiPassword"]').val(apiKey);
                    $('input[name="just_activate"]').val("1");
                    $('input[name="submitShopimind"]').trigger("click");
                }else {
                    $("#submitRemoteRegister").removeAttr("disabled");
                    $("#submitRemoteRegister").attr("value",defaultSubmitValue);
                    alert("{/literal}{l s='Please check the errors in the form.' mod='shopimind'}{literal}");
                    $form.displayFormErrors(response.messages);
                }
            },
            error:function(xhr,status,error){
                $("#submitRemoteRegister").removeAttr("disabled");
                $("#submitRemoteRegister").attr("value",defaultSubmitValue);
                alert(status);
            }
        });
    });

    var $form = null;

    var setFormErrorsMsg = function (objMSG, subFormName) {
        for (fieldKey in objMSG) {
            if (typeof objMSG[fieldKey] === 'object') {
                if (typeof subFormName === 'undefined') {
                    sub = fieldKey;
                } else {
                    sub = subFormName + '[' + fieldKey + ']';
                }

                setFormErrorsMsg(objMSG[fieldKey], sub);
            }
            else {
                var $li = $("<li></li>").append(objMSG[fieldKey]),
                    $parent = null;

                if ($('label[for="' + subFormName + '"]', $form).length > 0) {
                    $parent = $('label[for="' + subFormName + '"]', $form).parent(".control-group");

                    if ($parent.length === 0) {
                        $parent = $('label[for="' + subFormName + '"]', $form).parent();
                    }
                }
                else {
                    $parent = $('select[name="' + subFormName + '"], textarea[name="' + subFormName + '"],'+
                    ' input[name="' + subFormName + '"]', $form).parent(".controls");

                    if ($parent.length === 0) {
                        $parent = $('select[name="' + subFormName + '"], textarea[name="' + subFormName + '"],'+
                        ' input[name="' + subFormName + '"]', $form).parent("label");
                    }
                }

                if ($parent.find("ul.errors").length === 0) {
                    $parent.append($("<ul></ul>").addClass("errors"));
                }

                $parent.find("ul.errors").eq(0).append($li.hide());
                $li.slideDown().css("color","#cc0000");
            }
        }
    }

    $.fn.displayFormErrors = function (messages) {
        return this.each(function () {
            $form = $(this);
            setFormErrorsMsg(messages);
        });
    }
    {/literal}
</script>
