{*
 * Shopimind
 *
 * @author    Shopimind
 * @copyright Copyright (c) Shopimind 2021
 * @license   Commercial license
 *}

<fieldset id="configuration_form" class="shopimind" {if {$visibility|escape:'htmlall':'UTF-8'} == "hide"} style="display:none" {/if} >
    <legend style="background:#fff;"><img src="{$logo|escape:'htmlall':'UTF-8'}"  alt="" title=""/>
        {l s='Configuration of ShopiMind module' mod='shopimind'}
    </legend>

    <form method="post" action="" name="shopimindForm">
        <label for="apiIdentification">
            {l s='API login' mod='shopimind'}<span style="color:#cc0000;">*</span> :
        </label>
        <div class="margin-form">
            <input type="text" value="{$SPM_apiIdentification|escape:'htmlall':'UTF-8'}" name="apiIdentification" autocomplete="off" />
            <br /><br />
        </div>

        <label for="apiPassword">
            {l s='API password' mod='shopimind'}<span style="color:#cc0000;">*</span> :
        </label>
        <div class="margin-form">
            <input type="password" value="{$SPM_apiPassword|escape:'htmlall':'UTF-8'}" name="apiPassword" autocomplete="off" />
            <br /><br />
        </div>

        <label>{l s='Use real-time synchronization' mod='shopimind'}</label>
        <div class="margin-form">
            <input type="radio" name="realtimeSync" id="realtimeSync_on" value="1"
                    {if {$SPM_realtimeSync|escape:'htmlall':'UTF-8'} eq 1}
                        checked="checked"
                    {/if}
            />
            <label class="t" for="realtimeSync_on">
                <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
            </label>
            <input type="radio" name="realtimeSync" id="realtimeSync_off" value="0"
                {if {$SPM_realtimeSync|escape:'htmlall':'UTF-8'} eq 0}
                    checked="checked"
                {/if}
            />
            <label class="t" for="realtimeSync_off">
                <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
            </label>
            <p class="clear">
                {l s='Does the synchronization of your data have to be done in real time?' mod='shopimind'}
            </p>
        </div>

        <label>{l s='Cache workaround' mod='shopimind'}</label>
        <div class="margin-form">
            <input type="radio" name="cacheWorkaround" id="cacheWorkaround_on" value="1"
                    {if {$SPM_cacheWorkaround|escape:'htmlall':'UTF-8'} eq 1}
                        checked="checked"
                    {/if}
            />
            <label class="t" for="cacheWorkaround_on">
                <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
            </label>
            <input type="radio" name="cacheWorkaround" id="cacheWorkaround_off" value="0"
                    {if {$SPM_cacheWorkaround|escape:'htmlall':'UTF-8'} eq 0}
                        checked="checked"
                    {/if}
            />
            <label class="t" for="cacheWorkaround_off">
                <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
            </label>
            <p class="clear">
                {l s='Enable this mode if you are using a full page cache system.' mod='shopimind'}
            </p>
        </div>

        <label>{l s='Generate nominative vouchers?' mod='shopimind'}</label>
        <div class="margin-form">
            <input type="radio" name="voucherNominative" id="voucherNominative_on" value="1"
                {if {$SPM_voucherNominative|escape:'htmlall':'UTF-8'} eq 1}
                    checked="checked"
                {/if}
            />
            <label class="t" for="voucherNominative_on">
                <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
            </label>
            <input type="radio" name="voucherNominative" id="voucherNominative_off" value="0"
                {if {$SPM_voucherNominative|escape:'htmlall':'UTF-8'} eq 0}
                    checked="checked"
                {/if}
            />
            <label class="t" for="voucherNominative_off">
                <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
            </label>
            <p class="clear">
                {l s='Must ShopiMind vouchers be associated with your customers\' accounts (this means that your customer must be logged in to use it) ?' mod='shopimind'}
            </p>
        </div>

        {if {$PS_version|escape:'htmlall':'UTF-8'} >= '1.4'}
            <label class="voucherHighlight_display">{l s='Show the voucher in the cart ' mod='shopimind'}</label>
            <div class="margin-form voucherHighlight_display">
                <input type="radio" name="voucherHighlight" id="voucherHighlight_on" value="1"
                    {if {$SPM_voucherHighlight|escape:'htmlall':'UTF-8'} eq 1}
                        checked="checked"
                    {/if}
                />
                <label class="t" for="voucherHighlight_on">
                    <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
                </label>
                <input type="radio" name="voucherHighlight" id="voucherHighlight_off" value="0"
                    {if {$SPM_voucherHighlight|escape:'htmlall':'UTF-8'} eq 0}
                        checked="checked"
                    {/if}
                />
                <label class="t" for="voucherHighlight_off">
                    <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
                </label>
                <p class="clear">
                    {l s='If the voucher has not yet been added to the cart, it will be displayed under the cart in the order summary.' mod='shopimind'}
                </p>
            </div>
        {/if}

        {if {$PS_version|escape:'htmlall':'UTF-8'} < '1.5'}
            <label>{l s='Vouchers can be combined with your promotions?' mod='shopimind'}</label>
            <div class="margin-form">
                <input type="radio" name="voucherCumulablePromo" id="voucherCumulablePromo_on" value="1"
                    {if {$SPM_voucherCumulablePromo|escape:'htmlall':'UTF-8'} eq 1}
                        checked="checked"
                    {/if}
                />
                <label class="t" for="voucherCumulablePromo_on">
                    <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
                </label>
                <input type="radio" name="voucherCumulablePromo" id="voucherCumulablePromo_off" value="0"
                    {if {$SPM_voucherCumulablePromo|escape:'htmlall':'UTF-8'} eq 0}
                        checked="checked"
                    {/if}
                />
                <label class="t" for="voucherCumulablePromo_off">
                    <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
                </label>
                <p class="clear">
                    {l s='Should vouchers generated by ShopiMind be combined with your current promotions?' mod='shopimind'}
                </p>
            </div>
        {/if}

        <label>{l s='Vouchers can be combined with other codes?' mod='shopimind'}</label>
        <div class="margin-form">
            <input type="radio" name="voucherCumulableVoucher" id="voucherCumulableVoucher_on" value="1"
                {if {$SPM_voucherCumulableVoucher|escape:'htmlall':'UTF-8'} eq 1}
                   checked="checked"
                {/if}
            />
            <label class="t" for="voucherCumulableVoucher_on">
                <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
            </label>
            <input type="radio" name="voucherCumulableVoucher" id="voucherCumulableVoucher_off" value="0"
                {if {$SPM_voucherCumulableVoucher|escape:'htmlall':'UTF-8'} eq 0}
                    checked="checked"
                {/if}
            />
            <label class="t" for="voucherCumulableVoucher_off">
                <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
            </label>
            <p class="clear">
                {l s='Should vouchers generated by ShopiMind be combined with other promotional codes?' mod='shopimind'}
            </p>
        </div>

        <label>{l s='Deactivate out-of-stock products ?' mod='shopimind'}</label>
        <div class="margin-form">
            <input type="radio" name="excludeOutOfStockProducts" id="excludeOutOfStockProducts_on" value="1"
                    {if {$SPM_excludeOutOfStockProducts|escape:'htmlall':'UTF-8'} eq 1}
                        checked="checked"
                    {/if}
            />
            <label class="t" for="excludeOutOfStockProducts_on">
                <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
            </label>
            <input type="radio" name="excludeOutOfStockProducts" id="excludeOutOfStockProducts_off" value="0"
                    {if {$SPM_excludeOutOfStockProducts|escape:'htmlall':'UTF-8'} eq 0}
                        checked="checked"
                    {/if}
            />
            <label class="t" for="excludeOutOfStockProducts_off">
                <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
            </label>
            <p class="clear">
                {l s='Would you like to define out-of-stock products as deactivated?' mod='shopimind'}
            </p>
        </div>

        <label>{l s='Product image format to use in my emails' mod='shopimind'}</label>
        <div class="margin-form">
            <select name="productImageSize">
                <option value="">{l s='Automatic' mod='shopimind'}</option>
                {foreach from=$productImageSizes key=k item=v}
                    {if {$currentProductImageSize|escape:'htmlall':'UTF-8'} eq {$k}}
                        <option value="{$k|escape:'htmlall':'UTF-8'}" selected="selected">
                            {$v|escape:'htmlall':'UTF-8'}
                        </option>
                    {else}
                        <option value="{$k|escape:'htmlall':'UTF-8'}">
                            {$v|escape:'htmlall':'UTF-8'}
                        </option>
                    {/if}
                {/foreach}
            </select>
            <p class="clear">
                {l s='This is the image format that will be used in your product recalls and recommendations.' mod='shopimind'}
            </p>
        </div>

        <label>{l s='Synchronize your newsletter subscribers?' mod='shopimind'}</label>
        <div class="margin-form">
            <input type="radio" name="syncNL" id="syncNL_on" value="1"
                {if {$SPM_syncNL|escape:'htmlall':'UTF-8'} eq 1}
                    checked="checked"
                {/if}
            />
            <label class="t" for="syncNL_on">
                <img src="../img/admin/enabled.gif" alt="{l s='Enable' mod='shopimind'}" title="{l s='Enable' mod='shopimind'}" />
            </label>
            <input type="radio" name="syncNL" id="syncNL_off" value="0"
                {if {$SPM_syncNL|escape:'htmlall':'UTF-8'} eq 0}
                    checked="checked"
                {/if}
            />
            <label class="t" for="syncNL_off">
                <img src="../img/admin/disabled.gif" alt="{l s='Disable' mod='shopimind'}" title="{l s='Disable' mod='shopimind'}" />
            </label>
            <p class="clear">
                {l s='If you have a newsletter registration form on your store, we can retrieve emails from a dedicated mailing list.' mod='shopimind'}
            </p>
        </div>
        <div id="syncNL_config">
            <label>{l s='Table to synchronize' mod='shopimind'}</label>
            <div class="margin-form">
                <select name="syncNL_table" id="syncNL_table">
                    <option value="">{l s='Choose your table' mod='shopimind'}</option>
                    {foreach from=$tables_nl key=k item=table}
                        {if {$SPM_syncNL_table|escape:'htmlall':'UTF-8'} eq {$table|escape:'htmlall':'UTF-8'}}
                            <option value="{$table|escape:'htmlall':'UTF-8'}" selected="selected">
                                {$table|escape:'htmlall':'UTF-8'}
                            </option>
                        {else}
                            <option value="{$table|escape:'htmlall':'UTF-8'}">
                                {$table|escape:'htmlall':'UTF-8'}
                            </option>
                        {/if}
                    {/foreach}
                </select>
                <p class="clear">
                    {l s='This is the table in your database where the emails from your newsletter module are collected.' mod='shopimind'}
                </p>
            </div>
            <div id="syncNL_fields">
                <label>{l s='Field assignment' mod='shopimind'}</label>
                <div class="margin-form">
                </div>
                <p class="clear"></p>
            </div>
        </div>

        <input type="hidden" value="0" name="just_activate">
        <div style="text-align:center;">
            {if {$SPM_apiIdentification|escape:'htmlall':'UTF-8'} == ''}
                <input type="button" class="button spm_back_config_page" value="{l s='Back' mod='shopimind'}" />
            {/if}
            <input type="submit" class="button" name="submitShopimind" value="{l s='Submit' mod='shopimind'}" />
        </div>

    </form>
</fieldset>

<script type='text/javascript'>
    {literal}
    var currentFields;
    $(document).ready(function(){
        currentFields = '{/literal}{$fields|escape:'htmlall':'UTF-8'}{literal}';
        currentFields = currentFields.split(',');

        toggleVoucherHighlight();
        toggleSyncNL();
        toggleSyncNLFields();

        $('input[name=voucherNominative]').on('change',function(){
            toggleVoucherHighlight();
        });

        $('input[name=syncNL]').on('change',function(){
            toggleSyncNL();
        });

        $('select[name=syncNL_table]').on('change',function(){
            toggleSyncNLFields();
        });

    });

    function toggleVoucherHighlight(){
        if($('.voucherHighlight_display').length){
            if($('input[name=voucherNominative]:checked').val() == 1){
                $('.voucherHighlight_display').show();
            }else{
                $('.voucherHighlight_display').hide();
                $('input#voucherHighlight_off').attr('checked','checked');
            }
        }
    }

    function toggleSyncNL(){
        if($('#syncNL_config').length){
            if($('input[name=syncNL]:checked').val() == 1){
                $('#syncNL_config').show();
            }else{
                $('#syncNL_config').hide();
                $('input#syncNL_off').attr('checked','checked');
            }
        }
    }

    function toggleSyncNLFields(){
        if($('#syncNL_fields').length){
            if($('select[name=syncNL_table]').val() != ''){
                $('#syncNL_config').show();
                $('#syncNL_fields .margin-form').html("{/literal}{l s='Recovering fields from the table ...' mod='shopimind'}{literal}");

                $.ajax({
                    type: 'GET',
                    dataType: 'json',
                    url: "{/literal}{$url|escape:'htmlall':'UTF-8'}{literal}",
                    data: {action: 'getTableFields', table : $('select[name=syncNL_table]').val()},
                    success: function(response){
                        $('#syncNL_fields .margin-form').html('');
                        if(response.success && response.fields.length > 0) {
                            for(var i in response.fields) {
                                var emailRegex = /email/;
                                var div = $('<div class="spm_nl_div_1"></div>').html(
                                    '<div class="spm_nl_div_2">' + response.fields[i] + '</div>' +
                                    '<div style="margin-top: 3px; text-align: center;"> ' +
                                    '<select name="syncNL_fields[]" style="width: 100%;"> ' +
                                    '<option value="" ' + (currentFields.indexOf(response.fields[i]) == -1 ? 'selected="selected"' : '') + '>{/literal}{l s='Exclude' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-id_shop"  ' + (currentFields.indexOf(response.fields[i] + '-id_shop') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='ID Shop' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-last_name" ' +  (currentFields.indexOf(response.fields[i] + '-last_name') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Last Name' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-first_name" ' + (currentFields.indexOf(response.fields[i] + '-first_name') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='First Name' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-email" ' + (currentFields.indexOf(response.fields[i] + '-email') >= 0 || emailRegex.test(response.fields[i]) ? 'selected="selected"' : '') + '>{/literal}{l s='Email' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-zipcode" ' + (currentFields.indexOf(response.fields[i] + '-zipcode') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Zip code' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-last_update" ' + (currentFields.indexOf(response.fields[i] + '-last_update') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Date' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-status" ' + (currentFields.indexOf(response.fields[i] + '-status') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Status' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-lang" ' + (currentFields.indexOf(response.fields[i] + '-lang') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Lang' mod='shopimind'}{literal}</option>' +
                                    '</select>' +
                                    '</div>'
                                );
                                $('#syncNL_fields .margin-form').append(div);
                            }
                        }
                    }
                });
            }else{
                $('#syncNL_config').hide();
            }
        }
    }
    {/literal}
</script>
<style>
    .spm_nl_div_1 {
        float: left;
        padding: 5px 10px;
        background: #FFFFFF;
        border-radius: 3px;
        border: solid 1px lightgrey;
        top: 0;
        vertical-align: top;
        margin-right: 5px;
        margin-bottom: 5px;
    }
    .spm_nl_div_2 {
        margin-bottom: 5px;
        font-size: 12px;
        text-align: center;
        display: block;
    }
</style>
