<?php
/**
 * Call
 *
 * @author Shopimind <contact@shopimind.com>
 * @copyright Copyright (c) 2013 - IDVIVE SARL (http://www.idvive.com)
 * @license New BSD license (http://license.idvive.com)
 * @package Call
 * @version $Id call.php 2013-04-23$
 */

require_once dirname(__FILE__).'/src/Server.php';
require_once dirname(__FILE__).'/bin/Configuration.php';

$server = new ShopimindClientServer();

try {
    if ($server->isValid() === true) {
        if ($server->getTypeRequest() === 'sayHello') {
            require_once(dirname(__FILE__).'/../../../config/config.inc.php');
            if (!class_exists('ShopiMind', false)) {
                require_once(dirname(__FILE__).'/../shopimind.php');
            }

            $spm = new ShopiMind();
            $config = ShopimindClientConfiguration::getGlobalConfig();
            $server->sendResponse(array(
                'version' => $config['version'],
                'ecommerceVersion' => _PS_VERSION_,
                'moduleVersion' => $spm->version,
            ));
        } elseif ($server->getTypeRequest() === 'setScriptUrl') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'setScriptUrl')) {
                $params = $server->retrieveParams();
                ShopimindClientCallback::setScriptUrl($params['script_url']);

                $server->sendResponse(array(
                    'success' => true,
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'resetModule') {
            $spm = new ShopiMind();
            $return = false;

            if ($spm->uninstall() && $spm->install()) {
                $return = true;
            }

            $server->sendResponse(array(
                'success' => $return,
            ), true);
        } elseif ($server->getTypeRequest() === 'disableModule') {
            $spm = new ShopiMind();
            $spm->disable();

            $server->sendResponse(array(
                'success' => true,
            ), true);
        } elseif ($server->getTypeRequest() === 'dailyUpdate') {
            require_once dirname(__FILE__).'/callback.php';
            $response = array();
            if (method_exists('ShopimindClientCallback', 'deleteUnusedVouchers')) {
                $response['deleteUnusedVouchers'] = ShopimindClientCallback::deleteUnusedVouchers();
            }
            $server->sendResponse($response, true);
        } elseif ($server->getTypeRequest() === 'generateVouchers') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'generateVouchers')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'vouchers' => ShopimindClientCallback::generateVouchers(
                        $params['voucherInfos'],
                        $params['voucherEmails'],
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'getCustomerGroups') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'getCustomerGroups')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'customerGroups' => ShopimindClientCallback::getCustomerGroups(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'getLangs') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'getLangs')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'langs' => ShopimindClientCallback::getLangs(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncCustomers') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncCustomers')) {
                $params = $server->retrieveParams();
                $server->sendResponse(
                    array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'customers' => ShopimindClientCallback::syncCustomers(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idCustomer', $params) &&
                            $params['idCustomer']) ? $params['idCustomer'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                    ),
                    true
                );
            }
        } elseif ($server->getTypeRequest() === 'syncCustomersGroups') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncCustomersGroups')) {
                $params = $server->retrieveParams();
                $server->sendResponse(
                    array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'customersGroups' => ShopimindClientCallback::syncCustomersGroups(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idGroup', $params) &&
                            $params['idGroup']) ? $params['idGroup'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                        ),
                    true
                );
            }
        } elseif ($server->getTypeRequest() === 'syncManufacturers') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncManufacturers')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'manufacturers' => ShopimindClientCallback::syncManufacturers(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idManufacturer', $params) &&
                            $params['idManufacturer']) ? $params['idManufacturer'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncCarriers') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncCarriers')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'carriers' => ShopimindClientCallback::syncCarriers(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idCarrier', $params) &&
                            $params['idCarrier']) ? $params['idCarrier'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncProducts') {
            require_once dirname(__FILE__).'/callback.php';

            if (method_exists('ShopimindClientCallback', 'syncProducts')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'products' => ShopimindClientCallback::syncProducts(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idProduct', $params) &&
                            $params['idProduct']) ? $params['idProduct'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncProductsCategories') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncProductsCategories')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'productsCategories' => ShopimindClientCallback::syncProductsCategories(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idCategory', $params) &&
                            $params['idCategory']) ? $params['idCategory'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncOrdersStatus') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncOrdersStatus')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'ordersStatus' => ShopimindClientCallback::syncOrdersStatus(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idStatus', $params) &&
                            $params['idStatus']) ? $params['idStatus'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncOrders') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncOrders')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'orders' => ShopimindClientCallback::syncOrders(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idOrder', $params) &&
                            $params['idOrder']) ? $params['idOrder'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncNewsletters') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncNLSubscribers')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'newsletters' => ShopimindClientCallback::syncNLSubscribers(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'syncVouchers') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'syncVouchers')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'lastUpdate' => date('Y-m-d H:i:s'),
                    'vouchers' => ShopimindClientCallback::syncVouchers(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        ((array_key_exists('start', $params) &&
                            $params['start']) ? $params['start'] : false),
                        ((array_key_exists('limit', $params) &&
                            $params['limit']) ? $params['limit'] : false),
                        ((array_key_exists('lastUpdate', $params) &&
                            $params['lastUpdate']) ? $params['lastUpdate'] : false),
                        ((array_key_exists('idVoucher', $params) &&
                            $params['idVoucher']) ? $params['idVoucher'] : false),
                        ((array_key_exists('justCount', $params) &&
                            $params['justCount']) ? $params['justCount'] : false)
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'createCustomer') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'createCustomer')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'success' => ShopimindClientCallback::createCustomer(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        $params['customer']
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'unsubCustomer') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'unsubCustomer')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'success' => ShopimindClientCallback::unsubCustomer(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        $params['id_customer'],
                        $params['email']
                    ),
                ), true);
            }
        } elseif ($server->getTypeRequest() === 'subscribeCustomer') {
            require_once dirname(__FILE__).'/callback.php';
            if (method_exists('ShopimindClientCallback', 'subscribeCustomer')) {
                $params = $server->retrieveParams();
                $server->sendResponse(array(
                    'success' => ShopimindClientCallback::subscribeCustomer(
                        ((array_key_exists('shopIdShop', $params) &&
                            $params['shopIdShop']) ? $params['shopIdShop'] : false),
                        $params['id_customer']
                    ),
                ), true);
            }
        }
    }
} catch (Exception $e) {
    $server->sendResponse(array(
        'success' => false,
        'message' => $e->getMessage(),
        'stacktrace' => $e->getTrace(),
    ));
}
$server->sendResponse(array(), false);
