<?php
/**
 * AsyncCall
 *
 * @author Shopimind <contact@shopimind.com>
 * @copyright Copyright (c) 2013 - IDVIVE SARL (http://www.idvive.com)
 * @license New BSD license (http://license.idvive.com)
 * @package AsyncCall
 * @version $Id asyncCall.php 2013-04-23$
 */

if (array_key_exists('HTTP_ORIGIN', $_SERVER)) {
    header("Access-Control-Allow-Origin: ".$_SERVER['HTTP_ORIGIN']);
} else {
    if (array_key_exists('HTTP_REFERER', $_SERVER)) {
        $referer_url = parse_url($_SERVER['HTTP_REFERER']);
        $referer_url = $referer_url['scheme'].'://'.$referer_url['host'];
        header("Access-Control-Allow-Origin: ".$referer_url);
    } else {
        header("Access-Control-Allow-Origin: *");
    }
}

if (array_key_exists('action', $_GET)) {
    include_once dirname(__FILE__).'/callback.php';

    switch (Tools::getValue('action')) {
        case 'saveOrder':
            ShopimindClientCallback::saveOrder(Tools::getValue('id'));
            break;
        case 'saveProductCategory':
            ShopimindClientCallback::saveProductCategory(Tools::getValue('id'));
            break;
        case 'deleteProductCategory':
            ShopimindClientCallback::deleteProductCategory(Tools::getValue('id'));
            break;
        case 'saveCustomerGroup':
            ShopimindClientCallback::saveCustomerGroup(Tools::getValue('id'));
            break;
        case 'deleteCustomerGroup':
            ShopimindClientCallback::deleteCustomerGroup(Tools::getValue('id'));
            break;
        case 'saveManufacturer':
            ShopimindClientCallback::saveManufacturer(Tools::getValue('id'));
            break;
        case 'deleteManufacturer':
            ShopimindClientCallback::deleteManufacturer(Tools::getValue('id'));
            break;
        case 'saveCarrier':
            ShopimindClientCallback::saveCarrier(Tools::getValue('id'));
            break;
        case 'deleteCarrier':
            ShopimindClientCallback::deleteCarrier(Tools::getValue('id'));
            break;
        case 'saveVoucher':
            ShopimindClientCallback::saveVoucher(Tools::getValue('id'));
            break;
        case 'deleteVoucher':
            ShopimindClientCallback::deleteVoucher(Tools::getValue('id'));
            break;
        case 'saveOrderStatus':
            ShopimindClientCallback::saveOrderStatus(Tools::getValue('id'));
            break;
        case 'deleteOrderStatus':
            ShopimindClientCallback::deleteOrderStatus(Tools::getValue('id'));
            break;
        case 'saveProduct':
            ShopimindClientCallback::saveProduct(Tools::getValue('id'));
            break;
        case 'deleteProduct':
            ShopimindClientCallback::deleteProduct(Tools::getValue('id'));
            break;
        case 'saveCustomer':
            ShopimindClientCallback::saveCustomer(Tools::getValue('id'));
            break;
        case 'deleteCustomer':
            ShopimindClientCallback::deleteCustomer(Tools::getValue('id'));
            break;
        case 'getTableFields':
            echo ShopimindClientCallback::getTableFields(Tools::getValue('table'));
            break;
        default:
            break;
    }
}
exit;
